/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CBitmap.cpp,v 1.1 1999/09/12 04:29:43 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"

#include "UMath.h"
#include "CBitmap.h"
#include "CDC.h"
#include "CPalette.h"
#include "CRect.h"

_USING_PGP

// Class CBitmap member functions

CBitmap& 
CBitmap::operator=(HBITMAP bitmap)
{
	Attach(bitmap);
	return *this;
}

void 
CBitmap::PaintWithPalette(HDC dc, HPALETTE palette, CPoint origin) const
{
	pgpAssert(IsAttached());

	CDC	cdc(dc);

	if (IsntNull(palette))
	{
		cdc.SelectPalette(palette, FALSE);
		cdc.RealizePalette();
	}

	CDC	memDC;

	memDC.CreateCompatible(cdc);

	if (IsntNull(palette))
	{
		memDC.SelectPalette(palette, FALSE);
		memDC.RealizePalette();
	}

	HBITMAP	oldBitmap	= memDC.SelectObject(mBitmap);

	memDC.BitBlt(cdc, origin.X(), origin.Y(), origin.X() + mWidth, 
		origin.Y() + mHeight, 0, 0, SRCCOPY);

	memDC.SelectObject(oldBitmap);
	memDC.Clear();
}

void 
CBitmap::CreateCompatible(HDC hDC, PGPInt32 width, PGPInt32 height)
{
	Clear();
	mBitmap	= CreateCompatibleBitmap(hDC, width, height);

	if (IsNull(mBitmap))
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());

	mWeCreated = TRUE;
}

void 
CBitmap::CreateWithPalette(HINSTANCE instance, const char *name, CPalette& palette)
{
	Clear();

	HRSRC	rsrcBitmap	= FindResource(instance, name, RT_BITMAP);

	if (IsNull(rsrcBitmap))
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());

	HGLOBAL	hBitmap	= LoadResource(instance, rsrcBitmap);

	if (IsNull(hBitmap))
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());

	try
	{
		BITMAPINFO	*pBMI	= reinterpret_cast<BITMAPINFO *>(
			LockResource(hBitmap));

		if (IsNull(pBMI))
			THROW_PGPERROR(kPGPError_GraphicsOpFailed);

		try
		{
			BITMAPINFOHEADER	*pBMIH	= 
				reinterpret_cast<BITMAPINFOHEADER *>(pBMI);

			CDC	dc;
			dc.AttachFromWindow(NULL);

			PGPUInt32	numColors;
			palette.CreateDIB(pBMI, numColors);

			if (IsntNull(palette.Get()))
			{
				dc.SelectPalette(palette, FALSE);
				dc.RealizePalette();
			}

			mBitmap = CreateDIBitmap(dc, pBMIH, CBM_INIT, 
				reinterpret_cast<PGPByte *>(pBMIH) + pBMIH->biSize + 
				numColors * sizeof(RGBQUAD), 
				reinterpret_cast<BITMAPINFO *>(pBMIH), DIB_RGB_COLORS);

			if (IsNull(mBitmap))
				THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());

			mWidth = pBMIH->biWidth;
			mHeight = pBMIH->biHeight;

			dc.Clear();
			UnlockResource(hBitmap);
		}
		catch (CComboError&)
		{
			UnlockResource(hBitmap);
			throw;
		}

		FreeResource(hBitmap);
	}
	catch (CComboError&)
	{
		FreeResource(hBitmap);
		throw;
	}

	mWeCreated = TRUE;
}

void 
CBitmap::Load(HINSTANCE instance, const char *name, PGPBoolean shared)
{
	Clear();

	mBitmap = static_cast<HBITMAP>(
		LoadImage(instance, name, IMAGE_BITMAP, 0, 0, 
		shared ? LR_SHARED : 0));
	
	if (IsNull(mBitmap))
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());

	mWeCreated = TRUE;
}

void 
CBitmap::Attach(HBITMAP bitmap)
{
	if (mBitmap == bitmap)
		return;

	Clear();

	mWeCreated = FALSE;
	mBitmap = bitmap;
}

void 
CBitmap::Clear()
{
	if (WeCreated())
		DeleteObject(mBitmap);

	mWeCreated = FALSE;
	mBitmap = NULL;
}

HBITMAP 
CBitmap::Release()
{
	HBITMAP	oldBitmap	= mBitmap;

	mWeCreated = FALSE;
	mBitmap = NULL;
	
	return oldBitmap;
}
